# -*- coding: utf-8 -*-
"""
Created on Wed Oct 07 20:30:39 2015


"""

from CInputModule import CInputModule
from COutputModule import COutputModule
from CCalculateConcentrationsModule import CCalculateConcentrationsModule
from CPostProcessingModule import CPostProcessingModule
from CAnalysis import CAnalysis

import input_Calculation

# ToDo list
# CDomain - use properties instead of get/set
# To do: fix getting the depth/width properly
# change names of models
# CMF hydro remove t_settle?
# ADZ test with test parameters in ADZ.py
# concentrations YIndex defaults or remove
# fix initial concentration of ADE 2D
# improved Setup - maybe a separate file
# analysis.Models.YMidIndex should be a pointer & property combination
# change filepath to include timestamp
# print Analyses to console

class CMain(object):
    
    def __init__(self):       
        self.Analyses = []        
        self.InputModule = CInputModule()
        self.OutputModule = COutputModule()
        self.CalculateConcentrationsModule = CCalculateConcentrationsModule()
        self.PostProcessingModule = CPostProcessingModule()
        self.PostProcessingModule.Analyses = self.Analyses
        
        self._Filepath = 'c:\\temp\\python.pkl'

    @property
    def Filepath(self):
        return self._Filepath
    @Filepath.setter
    def Filepath(self,value):
        self._Filepath = value
        
    @property
    def Lengths(self):
        lengths = []
        for analysis in self.Analyses:
            lengths.append(analysis.River.Length)
        return lengths
    
    @property
    def AspectRatios(self):
        aspectratios = []
        for analysis in self.Analyses:
            aspectratios.append(analysis.River.Width/analysis.River.Depth)
        return aspectratios

    @property
    def Residuals(self):
        residuals = []
        residuals.append(self.PostProcessingModule.GetAdvectionOnlyResiduals())
        residuals.append(self.PostProcessingModule.GetAdvectionADELongitudinalResiduals())
        residuals.append(self.PostProcessingModule.GetAdvectionADZResiduals())        
        return residuals
    
    @property
    def MeantoShearVelocities(self):
        meantoshearvelocities = []
        for analysis in self.Analyses:
            meantoshearvelocities.append(analysis.River.MeanVelocityToShearVelocityRatio)
        return meantoshearvelocities
        
    @property
    def Widths(self):
        widths = []
        for analysis in self.Analyses:
            widths.append(analysis.River.Width)
        return widths
        
    def CalculateConcentrations(self):
        self.CalculateConcentrationsModule.CalculateConcentrations()

    def LoadAnalyses(self):
        analyses = self.InputModule.LoadObject(self.Filepath)
        #print "%d analyses loaded" % len(analyses) 

        if (analyses==[]):
            return

        self.Analyses = analyses        
        self.PostProcessingModule.Analyses = self.Analyses        
        self.Analysis = self.Analyses[0]
        self.SetupModules()

    def LoadDataInputs(self,ARiverIndex):
        self.InputModule.LoadDataInputs(ARiverIndex)
   
    def NumberOfRivers(self):
        return self.InputModule.NumberOfRivers()
    
    def PlotConcentrations(self):
        self.OutputModule.PlotConcentrationsVersusTime()     
        #self.OutputModule.PlotPeakConcentrationsVersusTime()     
        #self.OutputModule.PlotPeakConcentrationsVersusDistance()     
        self.OutputModule.PlotPeakConcentrationsNormalisedVersusTime()
        
#==============================================================================
#     def PlotExceedences(self):
#         self.CalculateExceedance()
#==============================================================================

    def PlotPeakConcentrationResiduals(self):
        self.PlotPeakConcentrationResidualsVersusWidths()
        #self.PlotPeakConcentrationResidualsVersusLengths()
    
    def PlotPeakConcentrationResidualsVersusLengths(self):
        self.OutputModule.PlotPeakConcentrationResiduals(self.Residuals,self.Lengths,'Residuals versus lengths','length (m)')
    
    def PlotPeakConcentrationResidualsVersusWidths(self):
        self.OutputModule.PlotPeakConcentrationResiduals(self.Residuals,self.Widths,'Residuals versus widths','width (m)')
        
    def PlotPeakConcentrationResidualsVersusAspectRatio(self):
        self.OutputModule.PlotPeakConcentrationResiduals(self.Residuals,self.AspectRatios,'Residuals versus aspect ratio','aspect ratio')
        print (self.AspectRatios )
    
    def PlotPeakConcentrationResidualsVersusMeantoShearVelocity(self):
        self.OutputModule.PlotPeakConcentrationResiduals(self.Residuals,self.MeantoShearVelocity,'Residuals versus mean to shear velocity ratio',' mean to shear velocity ratio')
        print (self.AspectRatios         )
        
    def PlotResiduals(self):
        #self.OutputModule.PlotPeakConcentrationsVersusTimeResiduals()   
        self.OutputModule.PlotNormalisedPeakConcentrationsVersusTimeResiduals()
        self.OutputModule.PrintAverageResiduals()        
    
    def PrintToConsole(self):
        self.OutputModule.PrintAnalysisToConsole()
        
    def RunAnalyses(self):              
        for river_index in range(0,self.NumberOfRivers()-5):
            # create analysis and make it available for the other modules
            self.Analysis = CAnalysis()
            self.Analyses.append(self.Analysis)
            self.SetupModules()
            
            # load inputs into the analysis data structure for this river
            self.LoadDataInputs(river_index)
                
            # setup the discretised analysis
            self.SetupAnalysis()
        
            # print input parameters and derived parameters
            self.PrintToConsole()
            
            # Calculate concentrations in CalculateConcentrations module
            self.CalculateConcentrations()
            
            # plot concentration graphs
            self.PlotConcentrations() 
            
            # plot residuals 
            self.PlotResiduals()
            
            # calculate number of exceedances 
            self.CalculateExceedance()
            

        print ('')
        print ('Saving to %s ' % self.Filepath)
        self.SaveAnalyses()

        print ('')
        print ('----------------------')
        print ('')
        
    def SaveAnalyses(self):
        self.OutputModule.SaveObject(self.Analyses,self.Filepath)        

    def SetupAnalysis(self):           
        analysis = self.Analysis
        river = analysis.River
        domain = analysis.Domain
        
        # Setup domain
        domain.X.Setup(0,river.Length,analysis.SpatialParameters.XStep)                
        domain.Y.Setup(-river.Width/2,river.Width/2,analysis.SpatialParameters.YStep)
        domain.SetupTimeSubdomain(river.MeanVelocity)        
        
        
        if not analysis.Validate():
            print ('fix time step')

        # Setup mixing parameters
        analysis.MixingParameters.Dx = input_Calculation.CalculateDispersionCoefficientElder(river.ShearVelocity, river.Depth, analysis.MixingParameters.DispersionElderX)
        analysis.MixingParameters.Dy = input_Calculation.CalculateDispersionCoefficientElder(river.ShearVelocity, river.Depth, analysis.MixingParameters.DispersionElderY)
        
        # Setup other parameters
        analysis.TBar = input_Calculation.CalculateTBar(analysis.MixingParameters.Dx, river.MeanVelocity, river.Length)
        analysis.Tau = input_Calculation.CalculateTau(analysis.TBar, analysis.MixingParameters.Dx, river.MeanVelocity, river.Length)

        # Setup intial concentrations
        # c_0 is an array, but for now is just length 1        
        c_0 = analysis.Pollutant.Mass/(river.Area * domain.X.Step)
        analysis.Pollutant.ConcentrationsInitial = [c_0]

        # Setup Concentrations arrays
        analysis.Models.AdvectionOnly.Setup(domain,c_0)
        analysis.Models.ADELongitudinal.Setup(domain,c_0)
        analysis.Models.ADETransverse.Setup(domain,c_0)
        analysis.Models.ADZ.Setup(domain,c_0)
        
        # Setup Models
        analysis.Models.YMidIndex = analysis.Domain.Y.MidIndex()
        
    def SetupModules(self):
        self.InputModule.SetAnalysis(self.Analysis)
        self.OutputModule.SetAnalysis(self.Analysis)
        self.CalculateConcentrationsModule.SetAnalysis(self.Analysis)
        
    def CalculateExceedance(self):
        self.OutputModule.CalculateExceedances()
    


        

        